/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.gui.internal.controller;

import de.willuhn.io.FileFinder;
import de.willuhn.jameica.gui.AbstractControl;
import de.willuhn.jameica.gui.AbstractView;
import de.willuhn.jameica.gui.parts.FormTextPart;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.util.InfoReader;
import de.willuhn.logging.Logger;
import de.willuhn.util.I18N;
import java.io.File;
import java.io.FileInputStream;

public class LicenseControl
extends AbstractControl {
    private FormTextPart libList = null;

    public LicenseControl(AbstractView view) {
        super(view);
    }

    public FormTextPart getLibList() {
        if (this.libList != null) {
            return this.libList;
        }
        I18N i18n = Application.getI18n();
        StringBuffer buffer = new StringBuffer();
        buffer.append("<form>");
        buffer.append("<p><span color=\"header\" font=\"header\">" + i18n.tr("Verwendete Komponenten") + "</span></p>");
        FileFinder finder = new FileFinder(new File("lib"));
        finder.matches(".*?info\\.xml$");
        File[] infos = finder.findRecursive();
        for (int i = 0; i < infos.length; ++i) {
            if (!infos[i].isFile() || !infos[i].canRead()) {
                Logger.warn((String)("unable to read " + infos[i] + ", skipping"));
                continue;
            }
            try {
                InfoReader ir = new InfoReader(new FileInputStream(infos[i]));
                buffer.append("<p>");
                buffer.append("<b>" + ir.getName() + "</b>");
                buffer.append("<br/>" + infos[i].getParentFile().getAbsolutePath());
                buffer.append("<br/>" + ir.getDescription());
                buffer.append("<br/>" + ir.getUrl());
                buffer.append("<br/>" + ir.getLicense());
                buffer.append("</p>");
                continue;
            }
            catch (Exception e) {
                Logger.error((String)("unable to parse " + infos[0]), (Throwable)e);
            }
        }
        buffer.append("</form>");
        this.libList = new FormTextPart(buffer.toString());
        return this.libList;
    }
}

